var EffectiveStops = new(function() {

    // jump through hoops for rhino
    function getRGB(r, g, b, a) {
        var val = ((a & 0xFF) << 24) | ((r & 0xFF) << 16) | ((g & 0xFF) << 8) | ((b & 0xFF) << 0);
        return new java.awt.Color(val, true);

    }

    this.Style = {
        BAR: 1,
        SHADE: 2

    };

    Object.freeze(this.Style);

    var defaultStyle = this.Style.BAR;

    this.setStyle = function(s) {
        defaultStyle = s;
    }

    addTreeFilter('ScaleFactor35efl,ShutterSpeed,FocalLength,FileName,Directory', 'EffectiveStops.match(ScaleFactor35efl,ShutterSpeed,FocalLength,FileName,Directory)');

    this.help = function() {
        var help = '<html>EffectiveStops<br>Graphically display effective stops of stabilization on thumbnail screen.<br>' +
            '<li>setMaxStops(int)</li><li>setStyle(style)</li></html>\nRequires ScaleFactor35efl tag to be in catalog.\n' +
            'style options: EffectiveStops.Style.BAR, EffectiveStops.Style.SHADE\n' +
            'Links with other thumbnail painters using thumbLink function from util.js';
        showMessage(help);
    }

    addUserCommand('effectivestops', function() {
        EffectiveStops.help();
    }, 'Help');

    var maxStops = 6;
    this.setMaxStops = function(ms) {
        maxStops = ms;
    }

    var imgMap = null;

    var onBuildTree = function(cat) {

        imgMap = new java.util.HashMap();
        getMap().remove("imgmap");
    }
    registerCallback('onBuildTree', onBuildTree);

    this.match = function(sfactor, ss, fl, fn, dir) {

        if (sfactor === '-' || ss === '-' || fl === '-') {

            return true; // nothing to do but always return true to include all images
        }
        fl = parseInt(fl.substring(0, fl.indexOf('.')));
	if(fl == 0) return true;

        var es = Math.log(dec(ss) / (1 / (fl * sfactor))) / Math.log(2);

        imgMap.put(fn + '' + dir, es);

        return true;

    }



    var done = function() {
        getMap().put("imgmap", imgMap);

    }
    registerCallback('done', done);

    imgMap = getMap().get("imgmap");
    var red = getRGB(255, 0, 0, 100);
    var green = getRGB(0, 255, 0, 100);
    var gray = getRGB(0, 0, 0, 100);

    var tpainter = function(gfx, image, ig, pp) {

        if (imgMap != null) {
            var val = pp.file + '' + pp.dir;
            if (imgMap.containsKey(val)) {
                var val = imgMap.get(val);

                switch (defaultStyle) {
                    case EffectiveStops.Style.BAR:
                        gfx.setColor(gray);
                        gfx.fillRect(0, pp.scaledHeight - 10, pp.scaledWidth, 8);

                        var st = Math.abs(val / maxStops);

                        var fill = pp.scaledWidth * st;
                        gfx.setColor(val < 0 ? green : red);
                        gfx.fillRect(0, pp.scaledHeight - 10, parseInt(fill, 10), 8);
                        break;
                    case EffectiveStops.Style.SHADE:
                        var st = Math.abs(val / maxStops);
                        var fade = 200 * st;
                        if (fade > 200) {
                            fade = 200;
                        }
                        if (val > 0) {
                            gfx.setColor(getRGB(255, 0, 0, fade));
                        } else {
                            gfx.setColor(getRGB(0, 255, 0, fade));
                        }
                        gfx.fillRect(0, 0, pp.scaledWidth, pp.scaledHeight);
                        break;
                }

            }
        }

    };


    setThumbnailPainter(tpainter);


    // allow linkage with other thumbnail painters
    // try catch in case UTIL not available
    try {
        UTIL.thumbLink(tpainter);
    } catch (e) {}


})();
