// Squint by Brad Grier
// Notes: Does not work with nashornopt '--lazy-compilation=false'. Fix not worth the overhead.

var Squint = new(function() {
    var rhino = script_engine_name === 'rhino';
    var nashorn = script_engine_name === 'nashorn';
    var showBackground = false;
    var shadeLetters = false;
    var fontSize = 8;
    var fontName = 'Monospaced';
    var font = new java.awt.Font(fontName, java.awt.Font.PLAIN, fontSize);
    var asciiSet = '$@#"^`\'. ';
    var calcString = null;
    var maxWidth = 0;
    var showInfo = false;
    var savePainter = null;
    var showBgImage = false;
    var heightOffset = 0;

    var aSets = [
        'abcdefghijklmnopqrstuvwxyz ~`!@#$%^&*()-_+=|\}]{[:;"\'<,>.?/',
        '$@#"^`\'. '
    ];

    this.help = function() {
        showMessage('<html>Squint<br>ASCII art creator. Activate from menu or CTRL+SHIFT+S<br><li>getPainter()<br><li>getPainter(fontname)<br><li>getPainter(fontname, fontsize)' +
            '<br><li>getPainter(fontName, fontSize, pattern)<br><li>getPainter(fontName, fontSize, pattern, showBackground bool)<br><li>getPainter(fontName, fontSize, pattern, showBackground bool, shadeLetters bool)<li>getPainter(fontName, fontSize, pattern, showBackground bool, shadeLetters bool, offset int)</html>' +
            'When opening Squint from the "User" menu, a UI dialog allows changing parameters in real time.\nThe configuration via UI does not affect the various getPainter() configurations');
    }

    addUserCommand('squint', function() {
        Squint.help();
    }, 'Help');

    var sb = function(sb) {

        showBackground = sb;
        JSI.repaintImage();
    }

    var sl = function(b) {
        shadeLetters = b;
        JSI.repaintImage();
    }

    var setFontSize = function(fs) {
        calcString = null;
        maxWidth = 0;
        fontSize = fs;
        font = font.deriveFont(java.awt.Font.PLAIN, fs);

        JSI.repaintImage();
    }

    var setFontName = function(fn) {
        calcString = null;
        maxWidth = 0;
        fontName = fn;

        font = new java.awt.Font(fontName, java.awt.Font.PLAIN, fontSize);
        JSI.repaintImage();

    }

    var setPattern = function(c) {
        calcString = null;
        maxWidth = 0;
        asciiSet = c;
        JSI.repaintImage();
    }

    var setShowInfo = function(b) {
        showInfo = b;
        JSI.repaintImage();
    }

    var showImage = function(b) {
        showBgImage = b;
        JSI.repaintImage();
    }

    var setOffset = function(b) {
        heightOffset = b;
        JSI.repaintImage();
    }

    // test each character and order pattern by darkest to lightest character
    function testChars(charWidth, charHeight, calcString, font, asciiSet) {
        if (calcString != null) {
            return calcString;
        } else {
            var img = new java.awt.image.BufferedImage(charWidth, charHeight, java.awt.image.BufferedImage.TYPE_INT_RGB);
            var graphics = img.createGraphics();
            graphics.setFont(font);
            var ca = [];
            var found = [];
            for (var i = 0; i < asciiSet.length; i++) {
                var asciiChar = asciiSet.charAt(i);
                if (found.indexOf(asciiChar) == -1) {
                    found[found.length] = asciiChar;
                    graphics.setColor(java.awt.Color.WHITE);
                    graphics.fillRect(0, 0, charWidth, charHeight);
                    graphics.setColor(java.awt.Color.BLACK);
                    graphics.drawString(asciiChar, 0, charHeight);
                    var sumGray = 0;
                    for (var offsetY = 0; offsetY < charHeight; offsetY++) {
                        for (var offsetX = 0; offsetX < charWidth; offsetX++) {
                            var pixelX = offsetX;
                            var pixelY = offsetY;
                            var pixel = img.getRGB(pixelX, pixelY);

                            var b = (pixel) & 0xff;
                            var g = (pixel >> 8) & 0xff;
                            var r = (pixel >> 16) & 0xff;
                            sumGray += rgbToGray(r, g, b);

                        }
                    }
                    var averageGray = Math.round(sumGray / (charWidth * charHeight));

                    var jo = new Object();
                    jo.character = asciiChar;
                    jo.gray = averageGray;
                    ca[ca.length] = jo;
                }
            }
            graphics.dispose();
            ca.sort(sortByGray('gray'));
            calcString = "";
            for (var i = 0; i < ca.length; i++) {

                calcString += ca[i].character;
            }
            return calcString;
        }
    }

    function sortByGray(property) {
        return function(a, b) {
            if (a[property] > b[property])
                return 1;
            else if (a[property] < b[property])
                return -1;
            return 0;
        }

    }

    // Function to convert RGB color to grayscale value
    function rgbToGray(r, g, b) {
        return Math.round(0.299 * r + 0.587 * g + 0.114 * b);
    }

    function createAsciiArt(image, font, maxWidth, calcString, asciiSet, showBackground, shadeLetters, heightOffset) {

        var width = image.getWidth();
        var height = image.getHeight();
        var asciiImage = new java.awt.image.BufferedImage(width, height, java.awt.image.BufferedImage.TYPE_INT_RGB);

        // Calculate character width and height based on the font
        var graphics = asciiImage.createGraphics();
        graphics.setFont(font);
        var fontMetrics = graphics.getFontMetrics(font);

        if (maxWidth == 0) {

            for (var i = 0; i < asciiSet.length; i++) {
                var w = fontMetrics.stringWidth(asciiSet.substring(i, i + 1));

                if (w > maxWidth) maxWidth = w;
            }
        }

        var charWidth = maxWidth;

        var ascent = fontMetrics.getAscent();
        var descent = fontMetrics.getDescent();
        var charHeight = ascent + descent - heightOffset;

        var orderedChars = testChars(charWidth, charHeight, calcString, font, asciiSet);

        var numCharsX = Math.floor(width / charWidth);
        var numCharsY = Math.floor(height / charHeight);


        if (showBgImage && !showBackground) {
            graphics.drawImage(image, 0, 0, null);
        } else {
            graphics.setColor(java.awt.Color.WHITE);
            graphics.fillRect(0, 0, width, height);

        }
        graphics.setFont(font);
        graphics.setRenderingHint(java.awt.RenderingHints.KEY_TEXT_ANTIALIASING, java.awt.RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setColor(java.awt.Color.BLACK);

        for (var y = 0; y < numCharsY; y++) {
            for (var x = 0; x < numCharsX; x++) {

                // Calculate the average grayscale value for this rectangular area
                var sumGray = 0;
                for (var offsetY = 0; offsetY < charHeight; offsetY++) {
                    for (var offsetX = 0; offsetX < charWidth; offsetX++) {
                        var pixelX = x * charWidth + offsetX;
                        var pixelY = y * charHeight + offsetY;
                        //var pixelColor = new Color(image.getRGB(pixelX, pixelY));
                        var pixel = image.getRGB(pixelX, pixelY);

                        var b = (pixel) & 0xff;
                        var g = (pixel >> 8) & 0xff;
                        var r = (pixel >> 16) & 0xff;
                        sumGray += rgbToGray(r, g, b);

                    }
                }
                var averageGray = Math.round(sumGray / (charWidth * charHeight));

                // Map the average grayscale value to an ASCII character
                var asciiIndex = Math.round((orderedChars.length - 1) * averageGray / 255);
                var asciiChar = orderedChars.charAt(asciiIndex);

                if (showBackground) {
                    //var cg = averageGray > 255 ? 255 : averageGray; // rhino workaround
                    graphics.setColor(getRGB(averageGray, averageGray, averageGray, 255));
                    graphics.fillRect(x * charWidth, y * charHeight, charWidth, charHeight);
                    graphics.setColor(java.awt.Color.BLACK);
                }

                if (shadeLetters) {
                    graphics.setColor(getRGB(averageGray, averageGray, averageGray, 255));
                }

                graphics.drawString(asciiChar, x * charWidth, (y + 1) * charHeight);

            }
        }

        if (showInfo) {
            var f = font.deriveFont(java.awt.Font.PLAIN, 12);
            graphics.setFont(f);
            fontMetrics = graphics.getFontMetrics(f);

            var s = fontName + ', size: ' + fontSize + ', characters: ' + (numCharsY * numCharsX) + ', spectrum: ' + orderedChars;

            graphics.setColor(java.awt.Color.BLACK);
            var r = fontMetrics.getStringBounds(s, graphics);
            graphics.fillRect(5, 30 - Math.floor(r.height) + fontMetrics.getDescent(), Math.floor(r.width) + 10, Math.floor(r.height) + fontMetrics.getDescent());
            graphics.setColor(java.awt.Color.RED);
            graphics.drawString(s, 10, 32);
        }
        graphics.dispose();
        return asciiImage;
    }

    // private painter used by the ui
    var getUIPainter = function() {

        var painter = function(gfx, image, img, pp) {
            var r = pp.getImageRect(image);
            var subimage = image.getSubimage(r.x, r.y, r.width, r.height);
            var ci = createAsciiArt(subimage, font, maxWidth, calcString, asciiSet, showBackground, shadeLetters, heightOffset);
            gfx.drawImage(ci, Math.max(pp.imageX, 0), Math.max(pp.imageY, 0), null);

        }

        return JSI.namedPainter(painter, 'SquintUI');
    }

    // This painter does not abide by the values set ubthe ui. Instead, pass in up to six args:
    // fontname, fontsize, pattern, showbackground, shadeletters, leading
    // args must appear order - missing args are set to defaults
    this.getPainter = function() {

        var showBackground = false;
        var shadeLetters = false;
        var showInfo = false;
        var fontSize = 8;
        var fontName = 'Monospaced';

        var asciiSet = '$@#"^`\'. ';

        if (arguments.length > 0) {
            fontName = arguments[0];
        }
        if (arguments.length > 1) {
            fontSize = arguments[1];
        }
        if (arguments.length > 2) {
            asciiSet = arguments[2];
        }
        if (arguments.length > 3) {
            showBackground = arguments[3];
        }
        if (arguments.length > 4) {
            shadeLetters = arguments[4];
        }
        if (arguments.length > 5) {

            heightOffset = arguments[5];
        }

        var font = new java.awt.Font(fontName, java.awt.Font.PLAIN, fontSize);
        var painter = function(gfx, image, img, pp) {
            var r = pp.getImageRect(image);
            var subimage = image.getSubimage(r.x, r.y, r.width, r.height);
            var font = new java.awt.Font(fontName, java.awt.Font.PLAIN, fontSize);
            var ci = createAsciiArt(subimage, font, 0, null, asciiSet, showBackground, shadeLetters, heightOffset);
            gfx.drawImage(ci, Math.max(pp.imageX, 0), Math.max(pp.imageY, 0), null);

        }

        return JSI.namedPainter(painter, 'Squint');
    }

    // jump through hoops for rhino
    function getRGB(r, g, b, a) {
        var val = ((a & 0xFF) << 24) | ((r & 0xFF) << 16) | ((g & 0xFF) << 8) | ((b & 0xFF) << 0);
        return new java.awt.Color(val, true);

    }


    // create the ui
    var sc = function() {
        var linked = false;
        try {
            linked = PAINTERLINKER.linked
        } catch (e) {}
        var currPainter = JSI.getPainter();

        var pId = UTIL.pID(currPainter);


        var active = pId.indexOf('SquintUI') != -1;

        if (linked && active) {
            setPainter(null, 'SquintUI');
        }
        setPainter(getUIPainter());

        savePainter = currPainter;

        var save = saveState(active);
        var si = function() {
            var jx = javax.swing;
            var awt = java.awt;
            var panel = new jx.JPanel(new awt.GridLayout(8, 1));

            var charPanel = new jx.JPanel(new awt.FlowLayout(awt.FlowLayout.LEFT));
            var pCombo = new jx.JComboBox(aSets);
            pCombo.setEditable(true);
            pCombo.setSelectedItem(asciiSet);

            pCombo.addActionListener(function(al) {
                var p = pCombo.getSelectedItem();
                if (aSets.indexOf(p + '') == -1) {
                    aSets[aSets.length] = p + ''; // +'' for rhino
                }

                setPattern(p + ''); // +'' for rhino
            });
            charPanel.add(new jx.JLabel('Characters:'));
            charPanel.add(pCombo);
            panel.add(charPanel);

            var fontPanel = new jx.JPanel(new awt.FlowLayout(awt.FlowLayout.LEFT));

            var names = java.awt.GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            fontPanel.add(new jx.JLabel('Font:'));
            var fontCombo = new jx.JComboBox(names);
            fontCombo.setSelectedItem(fontName);
            fontCombo.addActionListener(function(al) {
                var font = fontCombo.getSelectedItem();
                setFontName(font);

            });
            fontPanel.add(fontCombo);
            panel.add(fontPanel);

            var sizePanel = new jx.JPanel(new awt.FlowLayout(awt.FlowLayout.LEFT));

            sizePanel.add(new jx.JLabel('Size:'));
            var slider = new jx.JSlider(3, 20);
            slider.setValue(fontSize);
            slider.addChangeListener(function(ce) {
                setFontSize(slider.getValue());
                JSI.repaintImage();
            });
            sizePanel.add(slider);
            panel.add(sizePanel);

            var hPanel = new jx.JPanel(new awt.FlowLayout(awt.FlowLayout.LEFT));

            hPanel.add(new jx.JLabel('Offset:'));
            var hSlider = new jx.JSlider(0, 6);
            hSlider.setValue(heightOffset);
            hSlider.addChangeListener(function(ce) {
                setOffset(hSlider.getValue());
                JSI.repaintImage();
            });
            hPanel.add(hSlider);
            panel.add(hPanel);


            var bgCB = new jx.JCheckBox('Show Grid', showBackground);
            bgCB.addItemListener(function(il) {
                sb(il.getStateChange() == 1);
            });
            panel.add(bgCB);

            var shadeCB = new jx.JCheckBox('Shade Letters', shadeLetters);
            shadeCB.addItemListener(function(i2) {
                sl(i2.getStateChange() == 1);
            });
            panel.add(shadeCB);

            var infoCB = new jx.JCheckBox('Show Info', showInfo);
            infoCB.addItemListener(function(i2) {
                setShowInfo(i2.getStateChange() == 1);
            });
            panel.add(infoCB);

            var showCB = new jx.JCheckBox('Show Image', showBgImage);
            showCB.addItemListener(function(i2) {
                showImage(i2.getStateChange() == 1);
            });
            panel.add(showCB);

            return panel;
        }


        JSI.swingRequest(si, function(ok) {

            if (!ok) {

                if (!restoreState(save)) {
                    if (linked) {
                        setPainter(null, 'SquintUI');
                    } else {
                        setPainter(savePainter);
                        savePainter = null;
                    }
                } else {
                    if (linked) {

                        setPainter(null, 'SquintUI');
                    }
                    setPainter(new BufferedPainter(getUIPainter()));
                }
            } else {


                if (linked) {

                    setPainter(null, 'SquintUI');
                }
                setPainter(new BufferedPainter(getUIPainter()));

            }
        }, 'Squint - The ASCII Art Explorer');


    }

    addUserCommand("Squint", sc);
    // add a shortcut key - see Java's KeyEvent and InputEvent documentation
    JSI.addShortcut(sc, java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.CTRL_DOWN_MASK | java.awt.event.InputEvent.SHIFT_DOWN_MASK);

    function saveState(active) {
        var save = new Object();
        save.fontName = fontName;
        save.showBgImage = showBgImage;
        save.fontSize = fontSize;
        save.font = font;
        save.active = active;
        save.showBackground = showBackground;
        save.shadeLetters = shadeLetters;
        save.calcString = calcString;
        save.maxWidth = maxWidth;
        save.asciiSet = asciiSet;
        save.showInfo = showInfo;

        return save;


    }

    function restoreState(save) {
        showBgImage = save.showBgImage;
        fontName = save.fontName;
        fontSize = save.fontSize;
        font = save.font;
        showBackground = save.showBackground;
        shadeLetters = save.shadeLetters;
        calcString = save.calcString;
        maxWidth = save.maxWidth;
        asciiSet = save.asciiSet;
        showInfo = save.showInfo;
        return save.active;

    }


})();
